create table oik.oik_doc_switch_form
(
    id                uuid not null
        constraint oik_doc_switch_form_pkey
            primary key,
    content           bytea,
    original_filename text
);
			
alter table oik_doc_switch_form
	add constraint oik_doc_switch_form_oik_doc_id_fk
		foreign key (id) references oik_doc
			on delete cascade;

ALTER TABLE oik.oik_doc_switch_form
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_doc_switch_form TO oik_group_super;
GRANT ALL ON TABLE oik.oik_doc_switch_form TO postgres;



INSERT INTO oik_doc_default_content (doc_type, content) 
    VALUES (9, decode('${def_swtxt_1}', 'base64'));



create table oik_switch_form_log
(
    id         uuid      not null
        constraint oik_switch_form_log_pk
            primary key,
    doc_id     uuid      not null,
    doc_name   text      not null,
    start_time timestamp not null,
    end_time   timestamp,
    operator   text,
    inspector  text
);

alter table oik_switch_form_log
    owner to postgres;

GRANT SELECT ON TABLE oik.oik_switch_form_log TO oik_group_super;
GRANT ALL ON TABLE oik.oik_switch_form_log TO postgres;



create table oik_switch_form_log_steps
(
    form_id        uuid
        constraint oik_switch_form_log_steps_oik_switch_form_log_id_fk
            references oik_switch_form_log
            on delete cascade,
    time           timestamp not null,
    message        text      not null,
    action_message text      not null
);

create index oik_switch_form_log_steps_form_id_index
    on oik_switch_form_log_steps (form_id);

alter table oik_switch_form_log_steps
    owner to postgres;

GRANT SELECT ON TABLE oik.oik_switch_form_log_steps TO oik_group_super;
GRANT ALL ON TABLE oik.oik_switch_form_log_steps TO postgres;